//	*******************************************************************************
//	Name	:	EMF_fnc.hxx
//			:	EMF functions
//	Author	:	I. Nakagawa
//	Create	:	2020/10/13
//	Modify	:	2020/10/13	
//	*******************************************************************************

#pragma		once

#include	"W_strc_f.hxx"

////
//	*******************************************************************************
//	get draw rect
//	Create	:	2020/10/13
//	*******************************************************************************
inline	RECT	EMF_get_draw_rect	(LPCTSTR emf_path,const RECT& rect)
{
	RECT	draw_rect = rect ;
	{
		HENHMETAFILE	hEMF = ::GetEnhMetaFile(emf_path) ;
		double	width = ::RECT_width (draw_rect) ;
		double	height= ::RECT_height(draw_rect) ;
		ENHMETAHEADER	emh ;	::ZeroMemory(&emh,sizeof(ENHMETAHEADER)) ;
		emh.nSize = sizeof(ENHMETAHEADER) ;
		if (::GetEnhMetaFileHeader(hEMF,sizeof(emh),&emh) != 0) {
			{
				RECT	rectF =	{	0	} ;
				rectF.left	= emh.rclFrame.left ;
				rectF.top	= emh.rclFrame.top ;
				rectF.right	= emh.rclFrame.right ;
				rectF.bottom= emh.rclFrame.bottom ;
				width = ::RECT_width (rectF) ;
				height= ::RECT_height(rectF) ;
				}
			{
				RECT	rectB =	{	0	} ;
				rectB.left	= emh.rclBounds.left ;
				rectB.top	= emh.rclBounds.top ;
				rectB.right	= emh.rclBounds.right ;
				rectB.bottom= emh.rclBounds.bottom ;
				width = ::RECT_width (rectB) ;
				height= ::RECT_height(rectB) ;
				}
			}
		if (int(width)!=0 && int(height)!=0) {
			double	sizeX	  	= ::RECT_width (rect) ;
			double	sizeY	 	= ::RECT_height(rect) ;
			if (sizeX/width > sizeY/height)		{	sizeX = (sizeY*width/height) ;	}
			else								{	sizeY = (sizeX*height/width) ;	}
			POINT	lt =	{	0	} ;
			POINT	rb =	{	0	} ;
			lt.x = RECT_center(rect).x -int(sizeX/2) ;
			lt.y = RECT_center(rect).y -int(sizeY/2) ;
			rb.x = RECT_center(rect).x +int(sizeX/2) ;
			rb.y = RECT_center(rect).y +int(sizeY/2) ;
			draw_rect = ::RECT_set(lt,rb) ;
			}
		::DeleteEnhMetaFile(hEMF) ;
		}
	return	draw_rect ;
	}
