//	*******************************************************************************
//	Name	:	E_MF.hxx
//			:	Enhanced MetaFile
//	Author	:	I. Nakagawa
//	Create	:	2020/10/07
//	Modify	:	2020/10/13	
//	Modify	:	2025/11/19	delete include itls_tmp.hxx
//	*******************************************************************************

#pragma		once

//#include	<Windows.h>
#include	"EMF_fnc.hxx"

//#include	"itls_tmp.hxx"
//#include	"get_path.hxx"
inline	tstring	Get_TMP_path	(void)
{
	tstring	tmp_path ;
	size_t	size = MAX_PATH ;
	tmp_path.resize(size,0) ;
	::GetTempPath(DWORD(size),&tmp_path[0]) ;
	tmp_path = tstring(tmp_path.c_str()) ;
	return	tmp_path ;
	}

////
//	*******************************************************************************
//	Enhanced MetaFile
//	Create	:	2020/10/13
//	Modify	:	2025/11/19
//	*******************************************************************************
class	E_MetaF		{
public:
					E_MetaF			()						{	EMF_DC = NULL ;			}
					E_MetaF			(LPCTSTR emf_name)		{	EMF_DC = NULL ;	SetPathEMF(emf_name) ;	}
					~E_MetaF		()						{	Close() ;	}
public:
	virtual	bool	SetPathEMF		(LPCTSTR emf_name)		{	EMF_path = emf_name ;	return	true ;	}
	virtual	tstring	GetPathEMF		(void)	const			{	return	EMF_path ;		}
public:
	virtual	HDC		Get_HDC			(void)	{
										if (!Create())		{	return	NULL ;		}
										return	EMF_DC ;
										}
public:
	virtual	bool	Create			(LPCTSTR emf_name=NULL)	{
										if (emf_name != NULL) {	SetPathEMF(emf_name) ;	}
										if (GetPathEMF().empty()) {
											tstring	emf = ::Get_TMP_path() + _T("E_MetaF.emf") ;
											#ifdef	ITT_YMD
													emf = ::Path_AddLastSP(::Get_i_Tools_tmp_date()) ;
													emf+= ::Now_Format(_T("%H%M%S")) + _T(".emf") ;
											#endif
											SetPathEMF(emf.c_str()) ;
											}
										if (EMF_DC != NULL)	{	return	true ;		}
										EMF_DC = ::CreateEnhMetaFile(NULL,GetPathEMF().c_str(),NULL,NULL) ;
										return	(EMF_DC != NULL) ;
										}
	virtual	bool	Close			(void)	{
										if (EMF_DC == NULL)	{	return	true ;	}
										HENHMETAFILE	hEMF = ::CloseEnhMetaFile(Get_HDC()) ;
										if (hEMF != NULL) {
											::DeleteEnhMetaFile(hEMF) ;
											}
										return	true ;
										}
public:
	static	bool	Play			(HDC hdc,	LPCTSTR emf_path,const RECT& rect)	{
										HENHMETAFILE	hEMF = ::GetEnhMetaFile(emf_path) ;
										RECT			draw_rect = ::EMF_get_draw_rect(emf_path,rect) ;
										::PlayEnhMetaFile(hdc,hEMF,&draw_rect) ;
										::DeleteEnhMetaFile(hEMF) ;
										return	true ;
										}
	static	bool	Play			(HWND hwnd,	LPCTSTR emf_path)	{
										if (hwnd == NULL)			{	return	false ;		}
										RECT	rect =	{	0	} ;
										::GetClientRect(hwnd,&rect) ;
										bool	result = false ;
										{
											HDC		hdc  = ::GetDC(hwnd) ;
											result = Play(hdc,emf_path,rect) ;
											::ReleaseDC(hwnd,hdc) ;
											}
										return	result ;
										}
protected:
	HDC			EMF_DC ;
	tstring		EMF_path ;
	} ;

