//*******************************************************************************
//	Name	:	MS_tox64.hxx
//			:	ttoi64 , ttou64
//	Author	:	I. Nakagawa
//	Create	:	2013/02/28
//*******************************************************************************

#ifndef MSC_T_TO_X_64
#define MSC_T_TO_X_64

#ifndef	_tcstoui64

//	#define _istspace   isspace
//	#define	_istdigit	isdigit
//	#define	_istalpha	isalpha

//		...\VS 8\VC\crt\src\wcstoq.c
#define	FL_UNSIGNED		1		//	strtouq called
#define	FL_NEG			2		//	negative sign found
#define	FL_OVERFLOW		4		//	overflow occured
#define	FL_READDIGIT	8		//	we've read at least one correct digit

////
//*******************************************************************************
//	tcstoxq		...\VS 8\VC\crt\src\wcstoq.c
//	Create	:	2013/02/28
//*******************************************************************************
inline	u_64	tcstoxq	(LPCTSTR nptr,LPCTSTR* endptr,const int ibase_,const int flags_)
{
	int		ibase	= ibase_ ;
	int		flags	= flags_ ;
	const	TCHAR*	p = NULL ;
	TCHAR	c = 0 ;
	u_64	number = 0 ;

	if (endptr != NULL)	{	//	store beginning of string in endptr
		*endptr = (TCHAR*)nptr ;
	    }
	p = nptr ;
	number = 0 ;

	c = *p++ ;
	while	(_istspace((int)(unsigned)c))	{
		c = *p++ ;
		}
	if (c == '-')	{
		flags |= FL_NEG ;
		c = *p++ ;
		}
	else if (c == '+')	{
		c = *p++ ;
		}
	if (ibase < 0 || ibase == 1 || ibase > 36) {
		if (endptr)	{
			*endptr = nptr ;
			}
		return	0L ;
		}
	else if (ibase == 0)	{
		if		(c != '0')					{	ibase = 10 ;	}
		else if (*p == 'x' || *p == 'X')	{	ibase = 16 ;	}	//	c,p ... "0x"
		else								{	ibase =  8 ;	}
		}
	if (ibase == 16)	{
		if (c == '0' && (*p =='x' || *p == 'X'))	{
			++p ;
			c = *p++ ;
			}
		}

	u_64	maxval = _UI64_MAX / ibase ;
	for	(;;)	{
		u_32	digval = 0 ;
		if		(_istdigit((int)(unsigned char)c))	{	digval = c - '0' ;				}
		else if	(_istalpha((int)(unsigned char)c))	{	digval = toupper(c)-'A' + 10 ;	}
		else										{	break ;							}
		if (digval >= (unsigned)ibase)				{	break ;							}
		flags |= FL_READDIGIT ;
		if (number < maxval || (number == maxval && (u_64)digval <= _UI64_MAX%ibase)) {
			number = number * ibase + digval ;
			}
		else {
			flags |= FL_OVERFLOW ;
			if (endptr == NULL)						{	break ;							}
			}
		c = *p++ ;
		}

	--p ;
	if (!(flags & FL_READDIGIT)) {
		if (endptr)	{
			p = nptr ;
			}
		number = 0L ;
		}
	else if ((flags & FL_OVERFLOW) || (!(flags & FL_UNSIGNED) && (number & ((u_64)_I64_MAX+1)))) {
		errno = ERANGE ;
		if (flags & FL_UNSIGNED)	{	number = _UI64_MAX ;	}
		else						{	number = _I64_MAX ;		}
		}
	if (endptr != NULL)	{
		*endptr = p ;
		}
	if (flags & FL_NEG)	{
		number = (u_64)(-(i_64)number) ;
		}
	return	number ;
	}

////
//*******************************************************************************
//	ttox64
//	Create	:	2013/02/28
//*******************************************************************************
inline	i_64	_tcstoi64	(LPCTSTR nptr,LPCTSTR *endptr,int ibase)	{	return	tcstoxq(nptr,endptr,ibase,0) ;				}
inline	u_64	_tcstoui64	(LPCTSTR nptr,LPCTSTR *endptr,int ibase)	{	return	tcstoxq(nptr,endptr,ibase,FL_UNSIGNED) ;	}

#endif	//	_tcstoui64

#endif
