//	*******************************************************************************
//	Name	:	W_strc_f.hxx
//			:	Windows struct functions
//	Author	:	I. Nakagawa
//	Create	:	2020/10/13
//	Modify	:	2023/03/30	
//	Modify	:	2023/04/21	
//	*******************************************************************************

#pragma		once

#include	"i_def_aw.hxx"

////
//	*******************************************************************************
//	RECT
//	Create	:	2020/10/09
//	Modify	:	2020/10/22	add	RECT_set( POINT , SIZE )
//	Modify	:	2020/10/23	add	RECT_size
//	*******************************************************************************
//line	RECT	get_null_RECT	(void)			{	RECT	rect = {0} ;	return	rect ;	}
inline	long	RECT_width	(const RECT& rect)	{	return	(rect.right -rect.left) ;		}
inline	long	RECT_height	(const RECT& rect)	{	return	(rect.bottom- rect.top) ;		}

inline	SIZE	RECT_size	(const RECT& rect)
{
	SIZE	sz =	{	0	} ;
	sz.cx = ::RECT_width (rect) ;
	sz.cy = ::RECT_height(rect) ;
	return	sz ;
	}

inline	POINT	RECT_center	(const RECT& rect)
{
	POINT	cp	=	{	0	} ;
	cp.x = (rect.left+rect.right)/2 ;
	cp.y = (rect.top+rect.bottom)/2 ;
	return	cp ;
	}

inline	RECT	RECT_set	(const POINT& lt,const POINT& rb)
{
	RECT	rct	= 	{	0	} ;
	rct.left  	= lt.x ;
	rct.top   	= lt.y ;
	rct.right 	= rb.x ;
	rct.bottom	= rb.y ;
	return	rct ;
	}

inline	RECT	RECT_set	(const POINT& pt,const SIZE& sz)
{
	RECT	rct	= 	{	0	} ;
	rct.left  	= pt.x ;
	rct.top   	= pt.y ;
	rct.right 	= pt.x + sz.cx ;
	rct.bottom	= pt.y + sz.cy ;
	return	rct ;
	}

////
//	*******************************************************************************
//	POINT , SIZE
//	Create	:	2023/04/21
//	*******************************************************************************
inline	POINT	POINT_set	(const LONG x,const LONG y)
{
	POINT	point	= 	{	0	} ;
			point.x	= x ;
			point.y	= y ;
	return	point ;
	}

inline	SIZE	SIZE_set	(const LONG x,const LONG y)
{
	SIZE	size	= 	{	0	} ;
			size.cx	= x ;
			size.cy	= y ;
	return	size ;
	}

