//	*******************************************************************************
//	Name	:	_s_func.hxx
//			:	_s Functions
//	Author	:	I. Nakagawa
//	Create	:	2013/09/04
//	Modify	:	2013/09/06
//	Modify	:	2024/11/19
//	Modify	:	2025/07/25	add	_close
//	Modify	:	2025/08/01	_close
//	*******************************************************************************

#pragma		once

#include	<cstdio>
#include	<cstring>
#include	<fcntl.h>

#ifdef		_MSC_VER
#include	<direct.h>
#include	<io.h>
#else
#endif

#include	"gn_strlu.hxx"
#include	"tstring.hxx"

#ifndef		_tcslen
#define		_tcslen			strlen
#endif
#ifndef		_tcscpy
#define		_tcscpy			strcpy
#endif
#ifndef		_tcsncpy
#define		_tcsncpy		strncpy
#endif
#ifndef		_tcscat
#define		_tcscat			strcat
#endif
#ifndef		_tcsncat
#define		_tcsncat		strncat
#endif
#ifndef		_tcslwr
#define		_tcslwr			strlwr
#endif
#ifndef		_tcsupr
#define		_tcsupr			strupr
#endif
#ifndef		_tgetenv
#define		_tgetenv		getenv
#endif
#ifndef		_tfopen
#define		_tfopen			fopen
#endif
#ifndef		_tcreat
#define		_tcreat			creat
#endif

#ifdef		__GNUC__
#ifndef		_close
#define		_close			close
#endif
#endif

////
//	*******************************************************************************
//	string copy
//	Create	:	2006/04/06
//	Modify	:	2013/09/06
//	Modify	:	2020/05/01	check sizeD
//	*******************************************************************************
inline	bool	TcsCpy	(LPTSTR dst,size_t sizeD,LPCTSTR src)
{
	if (sizeD == 0)								{	return	false ;	}
	bool	rs = true ;
	#if(_MSC_VER >= 1400)
	{
		errno_t	err =	_tcscpy_s	(dst,sizeD,	src) ;
		if (err != 0)							{	rs = false ;	}
		}
	#else
	{
						_tcscpy 	(dst,		src) ;
		if (sizeD < _tcslen(src))				{	rs = false ;	}
		}
	#endif
	return	rs ;
	}

inline	bool	TcsNCpy	(LPTSTR dst,size_t sizeD,LPCTSTR src,size_t count)
{
	if (sizeD == 0)								{	return	false ;	}
	bool	rs = true ;
	#if(_MSC_VER >= 1400)
	{
		errno_t	err =	_tcsncpy_s	(dst,sizeD,	src,count) ;
		if (err != 0)							{	rs = false ;	}
		}
	#else
	{
						_tcsncpy	(dst,		src,count) ;
		if (sizeD < count)						{	rs = false ;	}
		}
	#endif
	return	rs ;
	}

inline	bool	TcsCat	(LPTSTR dst,size_t sizeD,LPCTSTR src)
{
	if (sizeD == 0)								{	return	false ;	}
	bool	rs = true ;
	#if(_MSC_VER >= 1400)
	{
		errno_t	err =	_tcscat_s	(dst,sizeD,	src) ;
		if (err != 0)							{	rs = false ;	}
		}
	#else
	{
						_tcscat 	(dst,		src) ;
		if (sizeD < _tcslen(src)+_tcslen(dst))	{	rs = false ;	}
		}
	#endif
	return	rs ;
	}

inline	bool	TcsNCat	(LPTSTR dst,size_t sizeD,LPCTSTR src,size_t count)
{
	if (sizeD == 0)								{	return	false ;	}
	bool	rs = true ;
	#ifdef	_WIN32_WCE
	{
						_tcsncat	(dst,		src,count) ;
		if (sizeD < _tcslen(src)+_tcslen(dst))	{	rs = false ;	}
		}
	#elif	(_MSC_VER >= 1400)
	{
		errno_t	err =	_tcsncat_s	(dst,sizeD,	src,count) ;
		if (err != 0)							{	rs = false ;	}
		}
	#else
	{
						_tcsncat	(dst,		src,count) ;
		if (sizeD < _tcslen(src)+_tcslen(dst))	{	rs = false ;	}
		}
	#endif
	return	rs ;
	}

////
//	*******************************************************************************
//	Memory Move
//	Create	:	2014/02/13
//	*******************************************************************************
inline	bool	MemMove		(void* dst,size_t sizeD,const void* src,size_t count)
{
	if (sizeD == 0)								{	return	false ;	}
	bool	rs = true ;
	#if(_MSC_VER >= 1400)
	{
		errno_t	err =	memmove_s	(dst,sizeD,	src,count) ;
		if (err != 0)							{	rs = false ;	}
		}
	#else
	{
						memmove 	(dst,		src,count) ;
		if (sizeD < count)						{	rs = false ;	}
		}
	#endif
	return	rs ;
	}

////
//	*******************************************************************************
//	string tolower , toupper
//	Create	:	2013/09/04
//	*******************************************************************************
inline	bool	TcsLwr	(LPTSTR dst,size_t sizeD)
{
	bool	rs = true ;
	#if(_MSC_VER >= 1400)
	{
		errno_t	err =	_tcslwr_s	(dst,sizeD) ;
		if (err != 0)	{	rs = false ;	}
		}
	#else
	{
						_tcslwr		(dst) ;
		}
	#endif
	return	rs ;
	}
inline	bool	TcsUpr	(LPTSTR dst,size_t sizeD)
{
	bool	rs = true ;
	#if(_MSC_VER >= 1400)
	{
		errno_t	err =	_tcsupr_s	(dst,sizeD) ;
		if (err != 0)	{	rs = false ;	}
		}
	#else
	{
						_tcsupr		(dst) ;
		}
	#endif
	return	rs ;
	}

////
//	*******************************************************************************
//	get env
//	Create	:	2013/09/04
//	*******************************************************************************
inline	tstring	TGetEnv	(c_tstring& var)
{
	tstring	env ;
	#if(_MSC_VER >= 1400)
	{
		bool	rs = true ;
		LPTSTR	pEnv = NULL ;
		errno_t	err	 =	_tdupenv_s(&pEnv,NULL,var.c_str()) ;
		if (err != 0)		{	rs = false ;	}
		if (pEnv != NULL)	{	env = pEnv ;	}
		::free(pEnv) ;
		}
	#else
	{
		LPTSTR	pEnv = _tgetenv(var.c_str()) ;
		if (pEnv != NULL)	{	env = pEnv ;	}
		}
	#endif
	return	env ;
	}

////
//	*******************************************************************************
//	create
//	Create	:	2013/09/05
//	*******************************************************************************
inline	int		TCreat	(c_tstring& fileName,const int mode)
{
	int		fh = 0 ;
	#if(_MSC_VER >= 1400)
	{
		bool	rs = true ;
		errno_t	err	 =	_tsopen_s(&fh,	fileName.c_str(),
								_O_CREAT|_O_WRONLY|_O_TRUNC,	_SH_DENYRW,		mode) ;
		if (err != 0)		{	rs = false ;	}
		}
	#else
	{
		fh			 =	_tcreat(		fileName.c_str(),						mode) ;
		}
	#endif
	return	fh ;
	}

////
//	*******************************************************************************
//	fopen
//	Create	:	2013/09/05
//	Modify	:	2017/09/20	check empty name
//	*******************************************************************************
inline	FILE*	TFOpen	(c_tstring& fileName,c_tstring& mode)
{
	FILE*	fp = NULL ;
	if (!fileName.empty()) {
		#if(_MSC_VER >= 1400)
		{
			bool	rs = true ;
			errno_t	err	 =	_tfopen_s(&fp,	fileName.c_str(),mode.c_str()) ;
			if (err != 0)		{	rs = false ;	}
			}
		#else
		{
			fp			 =	_tfopen(		fileName.c_str(),mode.c_str()) ;
			}
		#endif
		}
	return	fp ;
	}

