//	*******************************************************************************
//	Name	:	ask_cli.hxx
//			:	ask 
//	Author	:	I. Nakagawa
//	Create	:	2022/07/21
//	Modify	:	2022/07/25	
//	Modify	:	2022/11/30		std::streamsize
//	Modify	:	2023/09/28		add ::ask_cli_path		same ::ask_path_cli
//	*******************************************************************************

#pragma		once

#include	<iostream>
#include	"i_define.hxx"
#include	"tstring.hxx"
#include	"quotm.hxx"

////
//	*******************************************************************************
//	ask cli
//	Create	:	2022/07/21
//	Modify	:	2022/10/25
//	*******************************************************************************
inline	tstring	ask_cli	(LPCTSTR msg=_T(""))
{
	tstring	cli ;
	while(true)	{
		tstring	buf ;
		buf.resize(1000) ;
		std::terr << msg ;
		std::tin.getline(&buf[0],std::streamsize(buf.size())) ;
		buf = tstring(buf.c_str()) ;
		if		(buf == _T("q"))	{	break ;		}
		else if (buf == _T("Q"))	{	break ;		}
		if (buf.empty())			{	continue ;	}
		cli = buf.c_str() ;
		break ;
		}
	return	cli ;
	}

////
//	*******************************************************************************
//	ask path cli	==	ask_path.hxx  ::ask_path_cli
//	Create	:	2023/09/28
//	*******************************************************************************
inline	tstring	ask_cli_path	(LPCTSTR msg)
{
	tstring	path ;
	while(true)	{
		tstring	buf ;
		buf.resize(1000) ;
		std::terr << msg ;
		std::tin.getline(&buf[0],std::streamsize(buf.size())) ;
		buf = ::QuotM_Del_All(buf.c_str()) ;
		if		(buf == _T("q"))	{	break ;		}
		else if (buf == _T("Q"))	{	break ;		}
		if (buf.empty())			{	continue ;	}
		path = buf.c_str() ;
		break ;
		}
	return	path ;
	}

////
//	*******************************************************************************
//	ask wait
//	Create	:	2022/07/21
//	Modify	:	2022/11/30	std::streamsize
//	*******************************************************************************
inline	bool	ask_wait	(void)
{
	tstring	buf ;
	buf.resize(1000) ;
	std::terr << _T("wait...") ;
//	std::tin.getline(&buf[0],buf.size()) ;
	std::tin.getline(&buf[0],std::streamsize(buf.size())) ;
	return	true ;
	}

