//	*******************************************************************************
//	Name	:	con_wnd.hxx
//			:	Console AP functions
//	Author	:	I. Nakagawa
//	Create	:	2021/06/01
//	Modify	:	2023/03/09		add define GetConsoleWindow
//	*******************************************************************************

#pragma		once

#include	<Windows.h>
#include	"t_tstrng.hxx"

////
//	*******************************************************************************
//	console hwnd
//	https://docs.microsoft.com/ja-jp/troubleshoot/windows-server/performance/obtain-console-window-handle
//	Create	:	2021/06/01
//	*******************************************************************************
inline	HWND	GetConsoleHwnd(void)
{
	#define	MY_BUFSIZE	1024		//	Buffer size for console window titles.
	HWND	hwndFound = 0 ;			//	This is what is returned to the caller.
	tstring	newWindowTitle ;		//	Contains fabricated WindowTitle.
	tstring	oldWindowTitle ;		//	Contains original WindowTitle.
	oldWindowTitle.resize(MY_BUFSIZE) ;
	//	Fetch current window title.
	::GetConsoleTitle(&oldWindowTitle[0],MY_BUFSIZE) ;
	//	Format a "unique" NewWindowTitle.
	newWindowTitle = ::To_tstring(u_64(GetTickCount())) + _T("/") + ::To_tstring(u_64(GetCurrentProcessId())) ;
	//	Change current window title.
	::SetConsoleTitle(newWindowTitle.c_str()) ;
	//	Ensure window title has been updated.
	::Sleep(40) ;
	//	Look for NewWindowTitle.
	hwndFound = ::FindWindow(NULL,newWindowTitle.c_str()) ;
	//	Restore original window title.
	::SetConsoleTitle(oldWindowTitle.c_str()) ;
	return	(hwndFound) ;
	}

////
//	*******************************************************************************
//	define	GetConsoleWindow
//	Create	:	2023/03/09
//	*******************************************************************************
#if	(_WIN32_WINNT >= 0x0500)
//		HWND	hWnd =   ::	GetConsoleWindow() ;		//	WinCon.h
#else
//		HWND	hWnd =   ::	GetConsoleHwnd  () ;
#endif
#if	(_WIN32_WINNT >= 0x0500)
#else
#define	GetConsoleWindow	GetConsoleHwnd
#endif
