//	*******************************************************************************
//	Name	:	filepath.hxx
//			:	File Path Functions
//	Author	:	I. Nakagawa
//	Create	:	2013/08/30
//	Modify	:	2014/01/06
//	Modify	:	2014/05/13		Add parameter type  LPCTSTR
//	Modify	:	2020/01/27		Add ::Path_GetAbbreviate
//	Modify	:	2020/10/27		Add ::Path_Get_net_root
//	Modify	:	2024/11/19
//	*******************************************************************************

#pragma		once

#include	"strpath.hxx"
#include	"str_find.hxx"
#include	"str_uplw.hxx"

////
//	*******************************************************************************
//	c:\folder\file.dat	->	file.dat
//	Create	:	2013/09/02
//	Modify	:	2014/01/06
//	*******************************************************************************
inline	tstring	Path_GetName	(c_tstring& pathName_)
{
	tstring	pathName = pathName_ ;
	tstring::size_type	spPos = tstring::npos ;
	if (spPos == tstring::npos)	{	spPos = String_RFind(pathName,Path_SP_Win) ;	}
	if (spPos == tstring::npos)	{	spPos = String_RFind(pathName,Path_SP_GNU) ;	}
	tstring	fileName ;
//	if (spPos == tstring::npos)	{	fileName = _T("") ;								}
//	else						{	fileName = pathName.substr(spPos+1) ;			}
	if (spPos == tstring::npos)	{	fileName = pathName ;							}
	else						{	fileName = pathName.substr(spPos+1) ;			}
	return	fileName ;
	}

////
//	*******************************************************************************
//	c:\folder\file.dat	->	file
//	Create	:	2013/09/02
//	*******************************************************************************
inline	tstring	Path_GetTitle	(c_tstring& pathName_)
{
	tstring	fileName = ::Path_GetName(pathName_) ;
	tstring	fileTitle = _T("") ;
	if (fileName==_T("") || fileName==_T(" ") || fileName.find(_T('?')) != tstring::npos) {
		fileTitle = _T("") ;
		}
	else {
		tstring::size_type	spPos = ::String_RFind(fileName,_T('.')) ;
		if (spPos == tstring::npos)	{	fileTitle = fileName ;					}
		else						{	fileTitle = fileName.substr(0,spPos) ;	}
		}
	return	fileTitle ;
	}

////
//	*******************************************************************************
//	c:\folder\File.DAT	->	DAT
//	Create	:	2013/09/02
//	Modify	:	2019/12/11		non ext ... bug ?
//	*******************************************************************************
inline	tstring	Path_GetExt	(c_tstring& pathName_)
{
	tstring	fileName = ::Path_GetName(pathName_) ;
	tstring	fileExt = _T("") ;
	if (fileName==_T("") || fileName==_T(" ") || fileName.find(_T('?')) != tstring::npos) {
		fileExt = _T("") ;
		}
	else {
		tstring::size_type	spPos = ::String_RFind(fileName,_T('.')) ;
	//	if (spPos == tstring::npos)	{	fileExt = fileName ;					}
	//	else						{	fileExt = fileName.substr(spPos+1) ;	}
		if (spPos == tstring::npos)	{	fileExt = _T("") ;						}
		else						{	fileExt = fileName.substr(spPos+1) ;	}
		}
	return	fileExt ;
	}

////
//	*******************************************************************************
//	c:\folder\File.DAT	->	dat
//	Create	:	2013/09/02
//	*******************************************************************************
inline	tstring	Path_GetExtLow	(c_tstring pathName_)
{
	tstring	fileExt = ::Path_GetExt(pathName_) ;
			fileExt = ::String_ToLower(fileExt) ;
	return	fileExt ;
	}

////
//	*******************************************************************************
//	c:\folder\file.dat	->	c:\folder
//	Create	:	2013/08/30
//	*******************************************************************************
inline	tstring	Path_GetDir	(c_tstring& pathName_)
{
	tstring	pathName = pathName_ ;
	tstring::size_type	spPos = tstring::npos ;
	if (spPos == tstring::npos)	{	spPos = String_RFind(pathName,Path_SP_Win) ;	}
	if (spPos == tstring::npos)	{	spPos = String_RFind(pathName,Path_SP_GNU) ;	}
	tstring	fileDir ;
	if (spPos == tstring::npos)	{	fileDir = Path_SP ;								}
	else						{	fileDir = pathName.substr(0,spPos) ;			}
	return	fileDir ;
	}

////
//	*******************************************************************************
//	c:\folder\file.dat	->	c:foler\file
//	Create	:	2013/09/02
//	*******************************************************************************
inline	tstring	Path_GetBase	(c_tstring& pathName)
{
	tstring	dir		= ::Path_GetDir		(pathName) ;		//	c:\folder
	tstring	title	= ::Path_GetTitle	(pathName) ;		//	file
	tstring	ext		= ::Path_GetExt		(pathName) ;		//	dat
	return	::Path_AddLastSP(dir) + title ;
	}

////
//	*******************************************************************************
//	c:\folder\file.dat	->	c:\folder\file.txt
//	Create	:	2013/09/02
//	*******************************************************************************
inline	tstring	Path_ChangeExt	(c_tstring& pathName,LPCTSTR ext)
{
	tstring	newExt = ext ;
	{
		if		(newExt.empty())			{	newExt = _T("") ;			}
		else if	(newExt[0] == _T('.'))		{	newExt = ext ;				}
		else								{	newExt = _T(".") + newExt ;	}
		}
	tstring	base	= ::Path_GetBase	(pathName) ;
	tstring	newName = base + newExt ;
	return	newName ;
	}

////
//	*******************************************************************************
//	LPCTSTR type Functions
//	Create	:	2014/05/13
//	*******************************************************************************
inline	tstring	Path_GetName	(LPCTSTR pathName)				{	return	::Path_GetName	(tstring(pathName)) ;		}
inline	tstring	Path_GetTitle	(LPCTSTR pathName)				{	return	::Path_GetTitle	(tstring(pathName)) ;		}
inline	tstring	Path_GetExt		(LPCTSTR pathName)				{	return	::Path_GetExt	(tstring(pathName)) ;		}
inline	tstring	Path_GetExtLow	(LPCTSTR pathName)				{	return	::Path_GetExtLow(tstring(pathName)) ;		}
inline	tstring	Path_GetDir		(LPCTSTR pathName)				{	return	::Path_GetDir	(tstring(pathName)) ;		}
inline	tstring	Path_GetBase	(LPCTSTR pathName)				{	return	::Path_GetBase	(tstring(pathName)) ;		}
inline	tstring	Path_ChangeExt	(LPCTSTR pathName,LPCTSTR ext)	{	return	::Path_ChangeExt(tstring(pathName),ext);	}

////
//	*******************************************************************************
//	c:\folder\file.dat		->	c:
//	\\DevXP\Folder\File.dat	->	\\DevXP
//	Create	:	2013/09/02
//	*******************************************************************************
#ifdef	_MSC_VER
inline	tstring	Path_GetDrive	(c_tstring& pathName_)
{
	tstring	pathName = pathName_ ;
	tstring	drive ;
	if		(pathName.length() < 2)	{	drive = _T("") ;				}
	else if (pathName[1] == ':')	{	drive = pathName.substr(0,2) ;	}
	else {
		tstring	pre = pathName.substr(0,2) ;
		tstring	rest= pathName.substr(2) ;
		if (pre == _T("\\\\") || pre == _T("//")) {
			tstring::size_type	spPos = tstring::npos ;
			if (spPos == tstring::npos)	{	spPos = String__Find(rest,Path_SP_Win) ;	}
			if (spPos == tstring::npos)	{	spPos = String__Find(rest,Path_SP_GNU) ;	}
			if (spPos != tstring::npos) {
				drive = pre + rest.substr(0,spPos) ;
				}
			}
		}
	return	drive ;
	}

inline	int		Path_GetDriveNo	(c_tstring& pathName)
{
	tstring	fileDrive = Path_GetDrive(pathName) ;
	int		fileDriveNo = 0 ;
	if (fileDrive[1] == _T(':'))	{	fileDriveNo = toupper(fileDrive[0])-'A'+1 ;	}
	else							{	fileDriveNo = 0 ;							}
	return	fileDriveNo ;
	}
#endif	//	_MSC_VER

////
//	*******************************************************************************
//	"c:\folder\file.dat"		->	"c:\"
//	"\\DevXP\Folder\File.dat"	->	"\\DevXP\Folder\"
//	"/volume/Folder/File.dat"	->	"/volume/Folder/"
//	Create	:	2020/10/27
//	*******************************************************************************
inline	tstring	Path_Get_net_root	(c_tstring& path_name)
{
	if (path_name.length() < 4)		{	return	path_name ;		}
	bool	is_drive = (path_name[1]==_T(':')) ;
	tstring	net_root ;
	size_t	pos_1 = tstring::npos ;
	size_t	pos_2 = tstring::npos ;
			pos_1 = ::String__Find(path_name,Path_SP,2) ;
	if (pos_1 != tstring::npos) {
			pos_2 = ::String__Find(path_name,Path_SP,pos_1+1) ;
		}
	if (is_drive) {
			pos_2 = 2 ;
		}
	if (pos_2 == tstring::npos)		{	net_root = path_name ;						}
	else							{	net_root = path_name.substr(0,pos_2+1) ;	}
	return	net_root ;
	}

inline	tstring	Path_Get_net_root	(LPCTSTR path_name)		{	return	::Path_Get_net_root	(tstring(path_name)) ;		}

////
//	*******************************************************************************
//	c:\folder1\folder2\folder3\file.dat	->	c:\folder1\...\file.dat
//	c:\folder1\folder2\folder3\folder4\	->	c:\folder1\...\folder4\
//	(VS)\VC\atlmfc\src\mfc\filelist.cpp
//	Create	:	2020/01/27
//	Modify	:	2025/09/01	...\folder4\
//	*******************************************************************************
inline	tstring	Path_GetAbbreviate	(c_tstring& path_name_,const size_t len_max)
{
	tstring	abbr_name ;
	tstring	path_name = path_name_ ;
	{
		bool	is_lastSP = ::Path_LastIsSP (path_name) ;
		if (is_lastSP) {
			path_name = ::Path_DelLastSP(path_name) ;
			abbr_name = ::Path_GetAbbreviate(path_name,len_max-1) ;
			abbr_name = ::Path_AddLastSP(abbr_name) ;
			return	abbr_name ;
			}
		}
	size_t	len_full  = path_name.length() ;
	tstring	file_name = ::Path_GetName(path_name) ;
	size_t	len_name  = file_name.length() ;
	if (len_max >= len_full)			{	return	path_name ;		}
	if (len_max <  len_name)			{	return	file_name ;		}
	tstring	path_base ;
	#ifdef	_MSC_VER
			path_base = ::Path_GetDrive(path_name) ;
	#else
	#endif
	size_t	len_base  = path_base.length() ;
	abbr_name = path_base ;
	if (len_full - len_name > 3) {
		tstring::size_type	sp_pos = tstring::npos ;
		if (sp_pos == tstring::npos)	{	sp_pos = ::String__Find(path_name,Path_SP_Win,len_base+1) ;		}
		if (sp_pos == tstring::npos)	{	sp_pos = ::String__Find(path_name,Path_SP_GNU,len_base+1) ;		}
		if (sp_pos != tstring::npos)	{
			path_base = path_name.substr(0,sp_pos) ;
			}
		}
	len_base  = path_base.length() ;
	if (len_max < len_base+5+len_name)	{	return	file_name ;		}
	{
		abbr_name = ::Path_AddLastSP(path_base) + _T("...") ;
		abbr_name = ::Path_AddLastSP(abbr_name) + file_name ;
		}
	tstring	path_rest = path_name.substr(len_base+1) ;
	size_t	len_rest  = path_rest.length() ;
	while	(len_base + 5 + len_rest > len_max) {
		tstring::size_type	sp_pos = tstring::npos ;
		if (sp_pos == tstring::npos)	{	sp_pos = ::String__Find(path_rest,Path_SP_Win) ;		}
		if (sp_pos == tstring::npos)	{	sp_pos = ::String__Find(path_rest,Path_SP_GNU) ;		}
		if (sp_pos != tstring::npos)	{
			path_rest = path_rest.substr(sp_pos+1) ;
			}
		else {
			break ;
			}
		len_rest  = path_rest.length() ;
		}
	{
		abbr_name = ::Path_AddLastSP(path_base) + _T("...") ;
		abbr_name = ::Path_AddLastSP(abbr_name) + path_rest ;
		}
	return	abbr_name ;
	}

inline	tstring	Path_GetAbbreviate	(LPCTSTR path_name,const size_t len_max)	{	return	::Path_GetAbbreviate(tstring(path_name),len_max) ;		}

inline	tstring	Path_GetAbbreviate_2025_08	(c_tstring& path_name_,const size_t len_max)
{
	tstring	abbr_name ;
	tstring	path_name = path_name_ ;
	bool	is_lastSP = ::Path_LastIsSP (path_name) ;
			path_name = ::Path_DelLastSP(path_name) ;
	size_t	len_full  = path_name.length() ;
	tstring	file_name = ::Path_GetName(path_name) ;
	size_t	len_name  = file_name.length() ;
	if (len_max >= len_full)			{	return	path_name ;		}
	if (len_max <  len_name)			{	return	file_name ;		}
	tstring	path_base ;
	#ifdef	_MSC_VER
			path_base = ::Path_GetDrive(path_name) ;
	#else
	#endif
	size_t	len_base  = path_base.length() ;
	abbr_name = path_base ;
	if (len_full - len_name > 3) {
		tstring::size_type	sp_pos = tstring::npos ;
		if (sp_pos == tstring::npos)	{	sp_pos = ::String__Find(path_name,Path_SP_Win,len_base+1) ;		}
		if (sp_pos == tstring::npos)	{	sp_pos = ::String__Find(path_name,Path_SP_GNU,len_base+1) ;		}
		if (sp_pos != tstring::npos)	{
			path_base = path_name.substr(0,sp_pos) ;
			}
		}
	len_base  = path_base.length() ;
	if (len_max < len_base+5+len_name)	{	return	file_name ;		}
	{
		abbr_name = ::Path_AddLastSP(path_base) + _T("...") ;
		abbr_name = ::Path_AddLastSP(abbr_name) + file_name ;
		}
	tstring	path_rest = path_name.substr(len_base+1) ;
	size_t	len_rest  = path_rest.length() ;
	while	(len_base + 5 + len_rest > len_max) {
		tstring::size_type	sp_pos = tstring::npos ;
		if (sp_pos == tstring::npos)	{	sp_pos = ::String__Find(path_rest,Path_SP_Win) ;		}
		if (sp_pos == tstring::npos)	{	sp_pos = ::String__Find(path_rest,Path_SP_GNU) ;		}
		if (sp_pos != tstring::npos)	{
			path_rest = path_rest.substr(sp_pos+1) ;
			}
		else {
			break ;
			}
		len_rest  = path_rest.length() ;
		}
	{
		abbr_name = ::Path_AddLastSP(path_base) + _T("...") ;
		abbr_name = ::Path_AddLastSP(abbr_name) + path_rest ;
		}
	if (is_lastSP) {
		abbr_name = ::Path_AddLastSP(abbr_name) ;
		}
	return	abbr_name ;
	}

