//	*******************************************************************************
//	Name	:	quotm.hxx
//			:	Quotation Mark Functions
//	Author	:	I. Nakagawa
//	Create	:	2013/09/09
//	Modify	:	2013/10/04
//	Modify	:	2014/05/29		Add parameter type  LPCTSTR
//	Modify	:	2014/05/11		Add parameter type  v_tstring
//	Modify	:	2016/10/19		Add ::QuotM_Add(c_v_tstring)
//	Modify	:	2016/11/30		move Bracket Functions
//	Modify	:	2024/11/18
//	*******************************************************************************

#pragma		once

#include	"strary_f.hxx"
#include	"v_tstrng.hxx"

////
//	*******************************************************************************
//	Is Enclosed ?
//	Create	:	2007/12/12
//	Modify	:	2013/09/09
//	Modify	:	2016/11/30
//	*******************************************************************************
inline	bool	QuotM_IsEnclosed	(c_tstring& str)
{
	bool	isQuot = false ;
	if (str.length() < 2)						{	return	isQuot ;	}
	TCHAR	cl = str[0] ;
//	TCHAR	cr = str[str.length()-1] ;
	TCHAR	cr = ::String_GetLast_TC(str) ;
	if (cl == cr)	{
		if (cl == _T('\''))						{	isQuot = true ;		}
		if (cl == _T('\"'))						{	isQuot = true ;		}
		}
	return	isQuot ;
	}

////
//	*******************************************************************************
//	Add Quot
//	Create	:	2006/10/04
//	Modify	:	2013/09/09
//	Modify	:	2016/11/30
//	*******************************************************************************
inline	tstring	QuotM_Add	(c_tstring& str,const TCHAR q=_T('\"'))
{
	TCHAR	ql = q ;
	TCHAR	qr = q ;
	return	ql+str+qr ;
	}

////
//	*******************************************************************************
//	Delete Qout
//	Create	:	2006/10/04
//	Modify	:	2013/09/09
//	*******************************************************************************
inline	tstring	QuotM_Del	(c_tstring& str)
{
	if (!::QuotM_IsEnclosed(str))		{	return	str ;	}
	return	str.substr(1,str.length()-2) ;
	}

////
//	*******************************************************************************
//	Add Auto
//	Create	:	2007/12/12
//	Modify	:	2013/09/09
//	Modify	:	2014/05/29
//	Modify	:	2014/06/09
//	*******************************************************************************
inline	tstring	QuotM_Add_Auto	(c_tstring& str)
{
	if		(str.find(_T(','))	!= tstring::npos)	{	;				}
	else if	(str.find(_T('\t')) != tstring::npos)	{	;				}
	else if	(str.find(_T(' '))	!= tstring::npos)	{	;				}
	else if	(str.find(_T('\r'))	!= tstring::npos)	{	;				}	//	Add	2014/05/09
	else if	(str.find(_T('\n'))	!= tstring::npos)	{	;				}	//	Add	2014/05/09
	else											{	return	str ;	}
	if		(::QuotM_IsEnclosed	(str))				{	return	str ;	}	//	Add	2014/06/09
	return	::QuotM_Add(str) ;
	}

////
//	*******************************************************************************
//	Delete All
//	Create	:	2011/10/03
//	Modify	:	2013/09/09
//	*******************************************************************************
inline	tstring	QuotM_Del_All	(c_tstring& str_)
{
	tstring	str = str_ ;
	if (str.empty())					{	return	str ;	}
	for (size_t index=0 ; index<str.length() ; index++) {
		if (!::QuotM_IsEnclosed(str))	{	return	str ;	}
		str = ::QuotM_Del(str) ;
		}
	return	str ;
	}

////
//	*******************************************************************************
//	LPCTSTR type Functions
//	Create	:	2014/05/29
//	*******************************************************************************
inline	tstring	QuotM_Add		(LPCTSTR str,const TCHAR q=_T('\"'))	{	return	QuotM_Add		(tstring(str),	q) ;	}
inline	tstring	QuotM_Del		(LPCTSTR str)							{	return	QuotM_Del		(tstring(str)	) ;		}
inline	tstring	QuotM_Add_Auto	(LPCTSTR str)							{	return	QuotM_Add_Auto	(tstring(str)	) ;		}
inline	tstring	QuotM_Del_All	(LPCTSTR str)							{	return	QuotM_Del_All	(tstring(str)	) ;		}

////
//	*******************************************************************************
//	Add 
//	Create	:	2016/10/19
//	*******************************************************************************
inline	v_tstring	QuotM_Add		(c_v_tstring& strAry)
{
	v_tstring	add_sa ;
	for (size_t index=0 ; index<strAry.size() ; index++) {
		tstring	str = strAry[index] ;
				str = ::QuotM_Add(str) ;
		add_sa.push_back(str) ;
		}
	return	add_sa ;
	}

////
//	*******************************************************************************
//	Add Auto
//	Create	:	2014/06/11
//	*******************************************************************************
inline	v_tstring	QuotM_Add_Auto	(c_v_tstring& strAry)
{
	v_tstring	add_sa ;
	for (size_t index=0 ; index<strAry.size() ; index++) {
		tstring	str = strAry[index] ;
				str = ::QuotM_Add_Auto(str) ;
		add_sa.push_back(str) ;
		}
	return	add_sa ;
	}

////
//	*******************************************************************************
//	Delete All
//	Create	:	2014/06/11
//	*******************************************************************************
inline	v_tstring	QuotM_Del_All	(c_v_tstring& strAry)
{
	v_tstring	del_sa ;
	for (size_t index=0 ; index<strAry.size() ; index++) {
		tstring	str = strAry[index] ;
				str = ::QuotM_Del_All(str) ;
		del_sa.push_back(str) ;
		}
	return	del_sa ;
	}

