//	*******************************************************************************
//	Name	:	str_find.hxx
//			:	string find
//	Author	:	I. Nakagawa
//	Create	:	2024/11/18
//	Modify	:	2013/08/30
//			:	2013/12/24
//			:	2024/11/18
//			:	2025/06/20
//	*******************************************************************************

#pragma		once

#include	"i_define.hxx"
#include	"tstring.hxx"

#ifdef		_MBCS

////
//	*******************************************************************************
//	Find , Reverse Find
//	Create	:	2013/08/30
//	Modify	:	2013/12/24
//	*******************************************************************************
inline	tstring::size_type	MB_String_Find	(c_tstring& tstr,TCHAR ch,tstring::size_type pos/*=0*/)
{
	LPCTSTR	str = tstr.c_str()+pos ;
	LPCTSTR	fnd = _tcschr(str,ch) ;
	if (fnd == NULL)	{	return	tstring::npos ;	}
	return	(fnd-str+pos) ;
	}

inline	tstring::size_type	MB_StringRFind	(c_tstring& tstr,TCHAR ch)
{
	LPCTSTR	str = tstr.c_str() ;
	LPCTSTR	fnd = _tcsrchr(str,ch) ;
	if (fnd == NULL)	{	return	tstring::npos ;	}
	return	(fnd-str) ;
	}

////
//	*******************************************************************************
//	Find first of
//	Create	:	2013/12/24
//	*******************************************************************************
inline	tstring::size_type	MB_String_FindFirstOf	(c_tstring& tstr,LPCTSTR cs,tstring::size_type pos/*=0*/)
{
	LPCTSTR	str = tstr.c_str()+pos ;
	LPCTSTR	fnd = _tcspbrk(str,cs) ;
	if (fnd == NULL)	{	return	tstring::npos ;	}
	return	(fnd-str+pos) ;
	}

#endif	//	_MBCS

////
//	*******************************************************************************
//	Find
//	Create	:	2013/08/30
//	Modify	:	2013/12/24
//	*******************************************************************************
inline	tstring::size_type	String__Find	(c_tstring& tstr,TCHAR ch,tstring::size_type pos=0)
{
	#ifdef	_MBCS
		return	MB_String_Find(tstr,ch,pos) ;
	#else
		return	tstr.find(ch,pos) ;
	#endif
	}

////
//	*******************************************************************************
//	Reverse Find
//	Create	:	2013/08/30
//	Modify	:	2013/12/24
//	*******************************************************************************
inline	tstring::size_type	String_RFind	(c_tstring& tstr,TCHAR ch)
{
	#ifdef	_MBCS
		return	MB_StringRFind(tstr,ch) ;
	#else
		return	tstr.rfind(ch) ;
	#endif
	}

////
//	*******************************************************************************
//	Find first of
//	Create	:	2013/12/24
//	*******************************************************************************
inline	tstring::size_type	String_FindFirstOf	(c_tstring& tstr,LPCTSTR cs,tstring::size_type pos=0)
{
	#ifdef	_MBCS
		return	MB_String_FindFirstOf(tstr,cs,pos) ;
	#else
		return	tstr.find_first_of(cs,pos) ;
	#endif
	}

