//	*******************************************************************************
//	Name	:	str_join.hxx
//			:	string join
//	Author	:	I. Nakagawa
//	Create	:	2024/11/12
//	Modify	:	2025/08/01	
//	*******************************************************************************

#pragma		once

#include	"v_tstrng.hxx"

////
//	*******************************************************************************
//	Join
//	Create	:	2013/03/06
//	Modify	:	2013/12/24
//	Modify	:	2015/11/19	VC 6 - 8  recursive call	dev.mish.work
//	*******************************************************************************
#if(_MSC_VER >= 1500)		//	VC 9 -
inline	tstring	String_Join	(const std::vector<tstring>& srcAry,LPCTSTR sp)
{
	tstring	str ;
	#ifdef		MessageBar
	MessageBar	bar(_T("::String_Join ..."),srcAry.size()) ;
	#endif
	for (size_t index= 0 ; index<srcAry.size() ; index++) {
	#ifdef		MessageBar
		bar.SetBarInc() ;
	#endif
		str += srcAry[index] ;
		if (index+1 == srcAry.size())	{	continue ;	}
		str += sp ;
		}
	return	str ;
	}
#else						//	- VC 8
inline	tstring	String_Join	(const std::vector<tstring>& srcAry,LPCTSTR sp)
{
	tstring		str ;
	v_tstring	tmpSA ;
	tstring		tmpStr ;
	#ifdef		MessageBar
	MessageBar	bar(_T("::String_Join ..."),srcAry.size()) ;
	#endif
	for (size_t index= 0 ; index<srcAry.size() ; index++) {
	#ifdef		MessageBar
		bar.SetBarInc() ;
	#endif
		tmpStr += srcAry[index] ;
		if (index+1 == srcAry.size())	{	continue ;	}
		if ((index%128) == 100) {
			tmpSA.push_back(tmpStr) ;
			tmpStr.erase() ;
			continue ;
			}
		tmpStr += sp ;
		}
	if (!tmpStr.empty()) {
		tmpSA.push_back(tmpStr) ;
		}
	if (tmpSA.size() > 1) {
		str = ::String_Join(tmpSA,sp) ;
		}
	else if (tmpSA.size() == 1)	{
		str = tmpSA[0] ;
		}
	return	str ;
	}
#endif

inline	tstring	String_Join	(const std::vector<tstring>& srcAry,const tstring sp)
{
	return	::String_Join(srcAry,sp.c_str()) ;
	}
inline	tstring	String_Join	(const std::vector<tstring>& srcAry,const TCHAR sp=_T(' '))
{
	tstring	spStr ;	spStr = sp ;
	return	::String_Join(srcAry,spStr) ;
	}

