//	*******************************************************************************
//	Name	:	str_splt.hxx
//			:	string split
//	Author	:	I. Nakagawa
//	Create	:	2024/11/12
//	*******************************************************************************

#pragma		once

#include	"i_vector.hxx"
#include	"tstring.hxx"
#include	"_s_func.hxx"

#ifndef		_tcspbrk
#define		_tcspbrk		strpbrk
#endif
#ifndef		_tcsstr
#define		_tcsstr			strstr
#endif
#ifndef		_tcschr
#define		_tcschr			strchr
#endif

////
//	*******************************************************************************
//	Split
//	Create	:	2013/03/06
//	Modify	:	2013/09/02
//	Modify	:	2014/01/14	add isLine	...	split "\r\n"
//	Modify	:	2014/04/30	Bug		isLine Last CrLf
//	Modify	:	2016/05/16	Bug		_tcspbrk ... was not _mbspbrk
//	*******************************************************************************
inline	std::vector<tstring>	String_Split	(const tstring& str_,const bool isLine,LPCTSTR sp=_T("\r\n"))
{
	bool		mb_1 = false ;				//	MBCS 1 Byte
	#ifdef	_UNICODE
	#else
		if (_tcslen(sp) == 1) {
			if (sp[0] == '\\') {				//	0x5c
				mb_1 = true ;
				}
			}
	#endif
	std::vector<tstring>	strAry ;
	tstring		str = str_ ;
	LPCTSTR		pTmp = str.c_str() ;
	LPTSTR		pStart = LPTSTR(pTmp) ;
	LPTSTR		pFind = NULL ;
	while	(true) {
		if (*pStart == '\"') {				//	"---"
			pFind = _tcspbrk(pStart+1,_T("\"")) ;
			if (pFind == NULL)	{	break ;		}
			pFind = _tcspbrk(pFind+1,sp) ;
			}
		else if (*pStart == '\'') {			//	'---'
			pFind = _tcspbrk(pStart+1,_T("\'")) ;
			if (pFind == NULL)	{	break ;		}
			pFind = _tcspbrk(pFind+1,sp) ;
			}
		else {
			if (isLine)		{	pFind = _tcsstr (pStart,sp) ;	}
			else if (mb_1)	{	pFind = _tcschr	(pStart,sp[0]);	}
			else			{	pFind = _tcspbrk(pStart,sp) ;	}
			}
		if (pFind == NULL)	{	break ;		}
		int	bufLen = int(pFind-pStart+10) ;
		std::vector<TCHAR>	tmpStr ;
		tmpStr.resize(bufLen,0) ;
		::TcsNCpy(&tmpStr[0],bufLen,pStart,pFind-pStart) ;
		tstring	field = &tmpStr[0] ;
		strAry.push_back(field) ;
		if (isLine)		{	pFind += _tcslen(sp) ;	}
		else			{	pFind++ ;				}
		pStart = pFind ;
		}
	if (_tcslen(pStart) > 0) {
		strAry.push_back(pStart) ;
		}
	return	strAry ;
	}
inline	std::vector<tstring>	String_Split	(const tstring& str,const tstring sp)
{
	return	::String_Split(str,false,sp.c_str()) ;
	}
inline	std::vector<tstring>	String_Split	(const tstring& str,const TCHAR sp/*=_T(' ')*/)
{
	tstring	spStr ;	spStr = sp ;
	return	::String_Split(str,false,spStr.c_str()) ;
	}

