//	*******************************************************************************
//	Name	:	str_uplw.hxx
//			:	string to upper , to lower
//	Author	:	I. Nakagawa
//	Create	:	2024/11/18
//	Modify	:	2013/03/12
//			:	2014/05/09
//			:	2014/10/10	Add FindNoCase
//			:	2016/08/26	Add CompareNoCase
//			:	2017/03/02	
//			:	2024/11/18
//			:	2025/07/25
//	*******************************************************************************

#pragma		once

#include	"i_define.hxx"
#include	"tstring.hxx"
#include	"i_vector.hxx"
#include	"_s_func.hxx"

////
//	*******************************************************************************
//	To Lower
//	Create	:	2013/03/12
//	Modify	:	2014/05/09		Bug	TcsLwr length+1
//	*******************************************************************************
inline	tstring	String_ToLower	(c_tstring& str_)
{
	tstring	str = str_ ;
	#ifdef	__APPLE_CC__
		std::transform(str.begin(),str.end(),str.begin(),tolower) ;
	#else
//	#ifdef	_MSC_VER
	{
		std::vector<TCHAR>	tmpStr ;
		tmpStr.resize(str.length()+1) ;
		::TcsCpy(&tmpStr[0],str.length()+1,str.c_str()) ;
		::TcsLwr(&tmpStr[0],str.length()+1) ;
		str = &tmpStr[0] ;
		}
//	#else
	//	#ifndef	MONODEVELOP
	//		std::transform(str.begin(),str.end(),str.begin(),tolower) ;
	//	#endif
	#endif
	return	str ;
	}
////
//	*******************************************************************************
//	To Upper
//	Create	:	2013/03/12
//	Modify	:	2014/05/09		Bug	TcsUpr length+1
//	*******************************************************************************
inline	tstring	String_ToUpper	(c_tstring& str_)
{
	tstring	str = str_ ;
	#ifdef	__APPLE_CC__
		std::transform(str.begin(),str.end(),str.begin(),toupper) ;
	#else
//	#ifdef	_MSC_VER
	{
		std::vector<TCHAR>	tmpStr ;
		tmpStr.resize(str.length()+1) ;
		::TcsCpy(&tmpStr[0],str.length()+1,str.c_str()) ;
		::TcsUpr(&tmpStr[0],str.length()+1) ;
		str = &tmpStr[0] ;
		}
//	#else
	//	#ifndef	MONODEVELOP
	//		std::transform(str.begin(),str.end(),str.begin(),toupper) ;
	//	#endif
	#endif
	return	str ;
	}

////
//	*******************************************************************************
//	Compare No Case
//	Create	:	2016/08/26
//	Modify	:	2016/09/05		LPCTSTR		->	c_tstring&
//	*******************************************************************************
inline	bool	String_CompareNoCase	(c_tstring& str1,c_tstring& str2)
{
	tstring	tStr1 = str1 ;
	tstring	tStr2 = str2 ;
	if (tStr1 == tStr2)		{	return	true ;	}
	tStr1 = ::String_ToLower(tStr1) ;
	tStr2 = ::String_ToLower(tStr2) ;
	return	(tStr1 == tStr2) ;
	}
/*
inline	bool	String_CompareNoCase	(LPCTSTR str1,LPCTSTR str2)
{
	tstring	tStr1 = str1 ;
	tstring	tStr2 = str2 ;
	if (tStr1 == tStr2)		{	return	true ;	}
	tStr1 = ::String_ToLower(tStr1) ;
	tStr2 = ::String_ToLower(tStr2) ;
	return	(tStr1 == tStr2) ;
	}
inline	bool	String_CompareNoCase	(c_tstring& str1,c_tstring str2)	{
	return	::String_CompareNoCase(str1.c_str(),str2.c_str()) ;
	}
*/

////
//	*******************************************************************************
//	Find No Case
//	Create	:	2014/10/07
//	Modify	:	2016/09/05		LPCTSTR		->	c_tstring&
//	Modify	:	2017/03/02		Add pos
//	*******************************************************************************
inline	tstring::size_type	String_FindNoCase	(c_tstring& str1,c_tstring& str2,tstring::size_type pos=0)
{
	tstring	fStr1 = str1 ;
	size_t	fIndex = fStr1.find(str2,pos) ;
	if (fIndex != tstring::npos)	{	return	fIndex ;	}	//	found String ?
	tstring	fStr2 = str2 ;
	fStr1 = ::String_ToLower(fStr1) ;
	fStr2 = ::String_ToLower(fStr2) ;
	return	fStr1.find(fStr2,pos) ;								//	Find no case
	}
/*
inline	tstring::size_type	String_FindNoCase	(LPCTSTR str1,LPCTSTR str2)
{
	tstring	fStr1 = str1 ;
	size_t	fIndex = fStr1.find(str2) ;
	if (fIndex != tstring::npos)	{	return	fIndex ;	}	//	found String ?
	tstring	fStr2 = str2 ;
	fStr1 = ::String_ToLower(fStr1) ;
	fStr2 = ::String_ToLower(fStr2) ;
	return	fStr1.find(fStr2) ;									//	Find no case
	}
inline	tstring::size_type	String_FindNoCase	(c_tstring& str1,c_tstring str2)	{
	return	::String_FindNoCase(str1.c_str(),str2.c_str()) ;
	}
*/













/*
#ifdef		_MSC_VER
#pragma		warning	(disable	:	4786	)
#endif
#include	<algorithm>

#include	<locale>
#include	"i_define.hxx"
#include	"_tdefine.hxx"
#include	"tstring.hxx"
#include	"_s_func.hxx"
#include	"i_vector.hxx"
#include	"v_tstrng.hxx"
#include	"ttox.hxx"
#include	"t_tstrng.hxx"
#include	"tstrmbwc.hxx"

#ifndef		_istdigit
	#define	_istdigit	isdigit
#endif
#ifndef		_istspace
	#define	_istspace	isspace
#endif
#ifndef		_istalpha
	#define	_istalpha	isalpha
#endif
#ifndef		_istcntrl
	#define	_istcntrl	iscntrl
#endif

#ifdef		_DEBUG
#else
#include	"straryfc.hxx"
#endif
*/
