//	*******************************************************************************
//	Name	:	strary_f.hxx
//			:	vector<tstring>	functions
//	Author	:	I. Nakagawa
//	Create	:	2024/11/13
//	Modify	:	2013/01/30
//	Modify	:	2013/02/22
//	Modify	:	2013/09/03
//	Modify	:	2024/11/27
//	*******************************************************************************

#pragma		once

#ifdef		_MSC_VER
#pragma		warning	(disable	:	4786	)
#endif
#include	<vector>
#include	<algorithm>

#include	"tstring.hxx"
#include	"_s_func.hxx"

////
//	*******************************************************************************
//	Skip Empty String
//	Create	:	2013/01/30
//	Modify	:	2013/02/22
//	*******************************************************************************
inline	std::vector<tstring>	SkipEmpty	(const std::vector<tstring>& srcAry)
{
	std::vector<tstring>	strAry ;
	for (size_t index=0 ; index<srcAry.size() ; index++) {
		tstring	str = srcAry[index] ;
		if (str.empty())	{	continue ;	}
		strAry.push_back(str) ;
		}
	return	strAry ;
	}

////
//	*******************************************************************************
//	Sort String
//	Create	:	2013/01/30
//	*******************************************************************************
inline	std::vector<tstring>	Sort	(const std::vector<tstring>& srcAry)
{
	std::vector<tstring>	strAry = srcAry ;
	std::sort(strAry.begin(),strAry.end()) ;
	return	strAry ;
	}

////
//	*******************************************************************************
//	Reverse String
//	Create	:	2013/09/03
//	*******************************************************************************
inline	std::vector<tstring>	Reverse	(const std::vector<tstring>& srcAry)
{
	std::vector<tstring>	strAry = srcAry ;
	std::reverse(strAry.begin(),strAry.end()) ;
	return	strAry ;
	}

////
//	*******************************************************************************
//	Unique String
//	Create	:	2013/01/30
//	*******************************************************************************
inline	std::vector<tstring>	Unique	(const std::vector<tstring>& srcAry)
{
	std::vector<tstring>	strAry = srcAry ;
	std::sort(strAry.begin(),strAry.end()) ;
	std::vector<tstring>::iterator	uni = std::unique(strAry.begin(),strAry.end()) ;
	strAry.erase(uni,strAry.end()) ;
	return	strAry ;
	}

////
//	*******************************************************************************
//	Get Last char
//	Create	:	2013/03/01
//	Modify	:	2013/03/04
//	*******************************************************************************
inline	TCHAR	String_GetLast_TC	(c_tstring& str)
{
	if (str.length() == 0)	{	return	0 ;	}
	TCHAR	lastC = str.at(str.length()-1) ;
	#ifdef	_MBCS
	{
		std::vector<TCHAR>	tmpStr ;
		tmpStr.resize(str.length()+1) ;
		::TcsCpy(&tmpStr[0],str.length()+1,str.c_str()) ;
		_tcsrev(&tmpStr[0]) ;
		lastC = tmpStr.at(0) ;
		}
	#endif
	return	lastC ;
	}

////
//	*******************************************************************************
//	Is 7 bit ?
//	Create	:	2013/03/06
//	Modify	:	2013/03/07
//	*******************************************************************************
inline	bool	String_IsOnly7bit	(c_tstring& str_)
{
	tstring	str = str_ ;
	for (size_t index=0 ; index<str.length() ; index++) {
		TCHAR	ch = str[index] ;
		if (ch < 0 || 0x7f < ch)	{
			return	false ;
			}
		}
	return	true ;
	}

////
//	*******************************************************************************
//	Is 7 bit ?	String Array
//	Create	:	2014/06/19
//	*******************************************************************************
//inline	bool	String_IsOnly7bit	(               c_v_tstring& strAry)
inline		bool	String_IsOnly7bit	(const std::vector<tstring>& strAry)
{
	for (size_t index=0 ; index<strAry.size() ; index++) {
		tstring	str = strAry[index] ;
		if (!::String_IsOnly7bit(str))	{
			return	false ;
			}
		}
	return	true ;
	}

