//	*******************************************************************************
//	Name	:	strpath.hxx
//			:	String Path Functions
//	Author	:	I. Nakagawa
//	Create	:	2013/03/01
//	Modify	:	2013/09/02
//	Modify	:	2014/05/26		Add parameter type  LPCTSTR
//	Modify	:	2024/11/27
//	*******************************************************************************

#pragma		once

#include	"i_define.hxx"
#include	"str_splt.hxx"
#include	"str_join.hxx"
#include	"strary_f.hxx"

#define		Path_SP_Win		_T('\\')
#define		Path_SP_GNU		_T('/')
#define		Path_SP_Mac		Path_SP_GNU

#ifdef	_MSC_VER
	#define	Path_SP	Path_SP_Win
#else
	#define	Path_SP	Path_SP_GNU
#endif

////
//	*******************************************************************************
//	Check Char is SP
//	Create	:	2013/03/01
//	*******************************************************************************
inline	bool	Path__IsSP		(const TCHAR c)	{	return	(c==Path_SP_Win || c==Path_SP_Mac) ;	}
inline	bool	Path_1st_IsSP	(c_tstring& fold)
{
	if (fold.empty())							{	return	false ;	}
	return	Path__IsSP(fold.at(0)) ;
	}

inline	bool	Path_LastIsSP	(c_tstring& fold)
{
	if (fold.empty())							{	return	false ;	}
//	TCHAR	lastC = ::Path_String_GetLast(fold) ;
	TCHAR	lastC = ::String_GetLast_TC (fold) ;
	return	Path__IsSP(lastC) ;
	}

////
//	*******************************************************************************
//	Add / Del  SP
//	Create	:	2013/03/01
//	*******************************************************************************
inline	tstring	Path_AddLastSP	(c_tstring& folder,const TCHAR sp=Path_SP)
{
	tstring	fold = folder ;
	if (fold.empty())			{	return	fold ;	}
	if (!::Path_LastIsSP(fold))	{	fold += sp ;	}
	return	fold ;
	}
inline	tstring	Path_DelLastSP	(c_tstring& folder)
{
	tstring	fold = folder ;
	if (fold.empty())			{	return	fold ;	}
	if (::Path_LastIsSP(fold))	{	fold.resize(fold.length()-1) ;	}
	return	fold ;
	}
inline	tstring	Path_Del1st_SP	(c_tstring& folder)
{
	tstring	fold = folder ;
	if (fold.empty())			{	return	fold ;	}
	if (::Path_1st_IsSP(fold))	{	fold = fold.substr(1) ;	}
	return	fold ;
	}
inline	tstring	Path_Trim_SP	(c_tstring& folder)
{
	tstring	fold = folder ;
	if (fold.empty())			{	return	fold ;	}
	for (int index=0 ; index<10000 ; index++) {
		tstring	lastStr = fold ;
		fold = ::Path_DelLastSP(fold) ;
		fold = ::Path_Del1st_SP(fold) ;
		if (lastStr == fold)	{	break ;	}
		}
	return	fold ;
	}

////
//	*******************************************************************************
//	Normalization
//	\Folder1\Folder2/\Folder3//File.txt	->	\Folder1\Folder2\Folder3\File.txt
//											/Folder1/Folder2/Folder3/File.txt
//	Create	:	2013/09/02
//	*******************************************************************************
inline	tstring	Path_Normalize	(c_tstring& path_,const TCHAR sp=Path_SP)
{
	tstring	pathName = path_ ;
	{	//	\\\\Folder1\Folder2/\Folder3//File.txt		->		//Folder1/Folder2//Folder3//File.txt
		v_tstring	path_Ary ;
					path_Ary = ::String_Split	(pathName,Path_SP_Win) ;
					pathName = ::String_Join	(path_Ary,Path_SP) ;
					path_Ary = ::String_Split	(pathName,Path_SP_GNU) ;
					pathName = ::String_Join	(path_Ary,Path_SP) ;
		}
	{
		v_tstring	pathAry = ::String_Split	(pathName,Path_SP) ;
		v_tstring	new_Ary ;
		for (size_t index=0 ; index<pathAry.size() ; index++) {
			tstring	str = pathAry[index] ;
			if		(index == 0)	{	;			}		//	root
			else if	(index == 1)	{	;			}		//	unc
			else if (str.empty())	{	continue ;	}
			new_Ary.push_back(str) ;
			}
		pathName = ::String_Join	(new_Ary,sp) ;
		}
	return	pathName ;
	}

//	#endif

////
//	*******************************************************************************
//	LPCTSTR type Functions
//	Create	:	2014/05/26
//	*******************************************************************************
inline	tstring	Path_AddLastSP	(LPCTSTR folder,const TCHAR sp=Path_SP)		{	return	::Path_AddLastSP(tstring(folder),	sp) ;	}
inline	tstring	Path_DelLastSP	(LPCTSTR folder)							{	return	::Path_DelLastSP(tstring(folder)) ;			}
inline	tstring	Path_Normalize	(LPCTSTR path,	const TCHAR sp=Path_SP)		{	return	::Path_Normalize(tstring(path),		sp) ;	}


////
#ifdef		____________Old__2013_09_09____________
//	*******************************************************************************
//	Get Last char
//	Create	:	2013/03/01
//	Modify	:	2013/03/04
//	*******************************************************************************
inline	TCHAR	Path_String_GetLast	(c_tstring& str)
{
	if (str.length() == 0)	{	return	0 ;	}
	TCHAR	lastC = str.at(str.length()-1) ;
	#ifdef	_MBCS
	{
	//	tstring	tmpStr = str + _T("\0") ;	//	???
	//	_tcsrev(tmpStr.begin()) ;			//	reverse
		std::vector<TCHAR>	tmpStr ;
		tmpStr.resize(str.length()+1) ;
		_tcscpy(&tmpStr[0],str.c_str()) ;
		_tcsrev(&tmpStr[0]) ;
		lastC = tmpStr.at(0) ;
		}
	#endif
	return	lastC ;
	}
#endif	//	____________Old__2013_09_09____________
