//	*******************************************************************************
//	Name	:	t_tstrng.hxx
//			:	To tstring
//	Author	:	I. Nakagawa
//	Create	:	2013/08/22
//	Modify	:	2013/08/29
//	Modify	:	2017/06/06
//	Modify	:	2020/04/15
//	Modify	:	2020/04/23	check 1e50
//	*******************************************************************************

#pragma		once

#include	"xtot.hxx"
#include	"ttof.hxx"
#include	<sstream>
#include	<iostream>
//#include	<iomanip>

#ifndef		_istdigit
	#define	_istdigit	isdigit
#endif
#ifndef		_istspace
	#define	_istspace	isspace
#endif

////
//	*******************************************************************************
//	To tstring
//	Create	:	2013/08/22
//	*******************************************************************************
inline	tstring	To_tstring	(const i__8		v,const int r=10)	{	return	::i32tot(v,r) ;		}
inline	tstring	To_tstring	(const u__8		v,const int r=10)	{	return	::u32tot(v,r) ;		}
inline	tstring	To_tstring	(const i_16		v,const int r=10)	{	return	::i32tot(v,r) ;		}
inline	tstring	To_tstring	(const u_16		v,const int r=10)	{	return	::u32tot(v,r) ;		}
inline	tstring	To_tstring	(const i_32		v,const int r=10)	{	return	::i32tot(v,r) ;		}
inline	tstring	To_tstring	(const u_32		v,const int r=10)	{	return	::u32tot(v,r) ;		}
inline	tstring	To_tstring	(const i_64		v,const int r=10)	{	return	::i64tot(v,r) ;		}
inline	tstring	To_tstring	(const u_64		v,const int r=10)	{	return	::u64tot(v,r) ;		}
//		tstring	To_tstring	(const size_t	v,const int r=10)	{	return	::u64tot(v,r) ;		}

////
//	*******************************************************************************
//	To tstring	for gcc
//	Create	:	2017/06/24
//	*******************************************************************************
inline	tstring	To_tstring	(const long		v,const int r=10)	{	return	::i64tot(v,r) ;		}

////
//	*******************************************************************************
//	To tstring	with Thousands separator
//	Create	:	2013/08/22
//	*******************************************************************************
inline	tstring	To_tstring_cs	(const tstring& str)	{
	tstring	newStr ;
	tstring	tmpStr = str ;
	tstring::size_type	dotPos = str.find(_T('.')) ;
	if (dotPos != tstring::npos) {
		newStr = str.substr(dotPos) ;		//	Copy Fraction part
		tmpStr = str.substr(0,dotPos) ;
		}
	int		count = 0 ;
	size_t	csCount = 0 ;
	for (int index=int(tmpStr.length())-1 ; index>=0 ; index--) {
		TCHAR	tmpC = tmpStr[index] ;
		newStr = tmpC + newStr ;
		count++ ;
		if (count >= 3) {
			if (index > 1)	{
				TCHAR	tmp1 = tmpStr[index-1] ;
				if (_istdigit(tmp1)) {
					newStr = _T(',') + newStr ;
					csCount++ ;
					}
				}
			else if (index == 1) {
				TCHAR	tmp1 = tmpStr[0] ;
				if (_istdigit(tmp1)) {
					newStr = _T(',') + newStr ;
					csCount++ ;
					}
				else {
					;		//	Negative value
					}
				}
			count = 0 ;
			}
		}
	{	//	Delete left space
		tstring	tmp = newStr ;
		long	start = 0 ;
		for (size_t index=0 ; index<tmp.length() && index<csCount ; index++) {
			TCHAR	tmp1 = tmpStr[index] ;
			if (_istspace(tmp1)) {
				start++ ;
				}
			else {
				break ;
				}
			}
		if (start > 0) {
			newStr = tmp.substr(start) ;
			}
		}
	return	newStr ;
	}
inline	tstring	To_tstring_cs	(const i__8 	v)	{	return	::To_tstring_cs(::To_tstring(v)) ;	}
inline	tstring	To_tstring_cs	(const u__8 	v)	{	return	::To_tstring_cs(::To_tstring(v)) ;	}
inline	tstring	To_tstring_cs	(const i_16 	v)	{	return	::To_tstring_cs(::To_tstring(v)) ;	}
inline	tstring	To_tstring_cs	(const u_16 	v)	{	return	::To_tstring_cs(::To_tstring(v)) ;	}
inline	tstring	To_tstring_cs	(const i_32 	v)	{	return	::To_tstring_cs(::To_tstring(v)) ;	}
inline	tstring	To_tstring_cs	(const u_32 	v)	{	return	::To_tstring_cs(::To_tstring(v)) ;	}
inline	tstring	To_tstring_cs	(const i_64 	v)	{	return	::To_tstring_cs(::To_tstring(v)) ;	}
inline	tstring	To_tstring_cs	(const u_64 	v)	{	return	::To_tstring_cs(::To_tstring(v)) ;	}
//		tstring	To_tstring_cs	(const size_t	v)	{	return	::To_tstring_cs(::To_tstring(v)) ;	}

////
//	*******************************************************************************
//	To tstring	Remove or Replace fractional part 0
//	Create	:	2013/08/26
//	Modify	:	2020/04/15	bug sp == _T('0')
//	*******************************************************************************
inline	tstring	To_tstring_rz	(const tstring& str,const TCHAR sp=_T('\0'))	{
	tstring::size_type	dotPos	= str.find(_T('.')) ;
	tstring::size_type	pos_e	= str.find(_T('e')) ;
	tstring::size_type	pos_E	= str.find(_T('E')) ;
//	tstring::size_type	pos_p	= str.find(_T('+')) ;
//	tstring::size_type	pos_m	= str.find(_T('-')) ;
	if (sp == _T('0'))				{	return	str ;	}
	if (pos_e  != tstring::npos)	{	return	str	;	}
	if (pos_E  != tstring::npos)	{	return	str	;	}
//	if (pos_p  != tstring::npos)	{	return	str	;	}
//	if (pos_m  != tstring::npos)	{	return	str	;	}
	if (dotPos == tstring::npos)	{	return	str ;	}
	tstring	newStr ;
	tstring	tmpStr = str ;
	for (int index=int(tmpStr.length())-1 ; index>=0 ; index--) {
		TCHAR	tmpC = tmpStr[index] ;
		if (tmpC == _T('\0'))	{	continue ;	}
		if (tmpC == _T('0')) {
			tmpStr[index] = sp ;		//	'\0'
			}
		else if (tmpC == _T('.')) {
			tmpStr[index] = sp ;
			break ;
			}
		else if (!_istdigit(tmpC)) {	//	not value
			return	str ;
			}
		else {
			break ;						//	not 0 	exit loop
			}
		}
	newStr = tmpStr.c_str() ;
	return	newStr ;
	}

////
//	*******************************************************************************
//	Check use sprintf
//	Create	:	2017/06/06
//	Modify	:	2017/06/14
//	Modify	:	2023/04/24
//	*******************************************************************************
inline	bool	Check_use_sprintf	(void)
{
	double	checkValue = 0 ;
	double	resultValue= 0 ;
	{
		#ifdef	_OPENMP
			#pragma	omp	critical	(Check_use_sprintf)
		#endif
		{
			checkValue = 123 ;
			tstring	str ;
			std::tostringstream	strBuf ;
			{
				strBuf << checkValue ;
				}
			{
				str = strBuf.str() ;
				}
			resultValue = ::ttod(str.c_str()) ;
			#ifdef	_DEBUG
			if (long(checkValue)!=long(resultValue))
			{
				std::terr << long(checkValue) << _T("\t") << long(resultValue) << std::endl ;
				}
			#endif
			}
		}
	return	!(long(checkValue)==long(resultValue)) ;
	}

////
//	*******************************************************************************
//	To tstring	float
//	Create	:	2013/08/29
//	Modify	:	2017/06/06
//	Modify	:	2020/04/23	check 1e50
//	*******************************************************************************
#define	FTTW	0
#define	FTTP	6
inline	tstring	To_tstring	(const double v,const int w=FTTW,const int p=FTTP,const unsigned f_=std::ios::fixed)	{
	#if		(_MSC_VER >= 1400)
	#elif	_UNICODE
	#else
	{
		static	bool	use_sprintf = ::Check_use_sprintf() ;
		if (use_sprintf) {
			std::string	str ;
			tstring		fmt = _T("%.") + ::To_tstring(p) +  _T("f") ;
			str.resize(512,0) ;
			sprintf(&str[0],fmt.c_str(),v) ;
			return	str.c_str() ;
			}
		}
	#endif
	{
		tstring		str ;
		std::tostringstream	strBuf ;
		std::ios_base::fmtflags	f = std::ios_base::fmtflags(f_) ;
		if (f != 0)	{
			if (v<-1e50)	{	f = std::ios::scientific ;	}
			if (v> 1e50)	{	f = std::ios::scientific ;	}
			strBuf.flags(f) ;
			}
		{
			strBuf.width(w) ;
			strBuf.precision(p) ;
			}
		{
			strBuf << v ;
			}
		{
			str = strBuf.str() ;
			}
		return	str ;
		}
	}

inline	tstring	To_tstring_f	(const double v,const int w=FTTW,const int p=FTTP)	{	return	To_tstring	(v,w,p,std::ios::fixed) ;		}
inline	tstring	To_tstring_e	(const double v,const int w=FTTW,const int p=FTTP)	{	return	To_tstring	(v,w,p,std::ios::scientific) ;	}
inline	tstring	To_tstring_g	(const double v,const int w=FTTW,const int p=FTTP)	{	return	To_tstring	(v,w,p,0) ;						}
inline	tstring	To_tstring_rz	(const double v,const int w=FTTW,const int p=FTTP)	{	return	::To_tstring_rz(To_tstring_f(v,w,p)) ;		}
inline	tstring	To_tstring_rzs	(const double v,const TCHAR sp=_T(' '),
												const int w=FTTW,const int p=FTTP)	{	return	::To_tstring_rz(To_tstring_f(v,w,p),sp) ;	}

////
//	*******************************************************************************
//	To tstring	2048 -> "2.00 K"
//	http://en.wikipedia.org/wiki/Binary_prefix
//	http://ja.wikipedia.org/wiki/2%E9%80%B2%E6%8E%A5%E9%A0%AD%E8%BE%9E
//	Create	:	2013/08/22
//	Modify	:	2021/06/16	To_tstring_k	u_64 --> i_64
//	Modify	:	2023/04/24
//	*******************************************************************************
inline	tstring	To_tstring_Ki   (const i_64	value) {
	tstring	str ;
	i_64	Ki	 = 1024 ;
	i_64	kibi = 1	* Ki ;		//	2^10	10^3
	i_64	mebi = kibi * Ki ;		//	2^20	10^6
	i_64	gibi = mebi * Ki ;		//	2^30	10^9
	i_64	tebi = gibi * Ki ;		//	2^40	10^12
	i_64	pebi = tebi * Ki ;		//	2^50	10^15
	i_64	exbi = pebi * Ki ;		//	2^60	10^18
//	i128	zebi = exbi * Ki ;		//	2^70	10^21
//	i128	yobi = zebi * Ki ;		//	2^80	10^24
	long	lVal = 0 ;
	float	fVal = 0 ;
	tstring	symb ;
	int		vw = 6 ;
	int		vp = 2 ;
	if		(value>=pebi*1000)	{	lVal = long(value/(exbi)) ;		fVal = float(value)/float(exbi) ;		symb = _T(" E") ;	}
	else if	(value>=tebi*1000)	{	lVal = long(value/(pebi)) ;		fVal = float(value)/float(pebi) ;		symb = _T(" P") ;	}
	else if	(value>=gibi*1000)	{	lVal = long(value/(tebi)) ;		fVal = float(value)/float(tebi) ;		symb = _T(" T") ;	}
	else if	(value>=mebi*1000)	{	lVal = long(value/(gibi)) ;		fVal = float(value)/float(gibi) ;		symb = _T(" G") ;	}
	else if	(value>=kibi*1000)	{	lVal = long(value/(mebi)) ;		fVal = float(value)/float(mebi) ;		symb = _T(" M") ;	}
	else if	(value>=   1*1000)	{	lVal = long(value/(kibi)) ;		fVal = float(value)/float(kibi) ;		symb = _T(" K") ;	}
	else						{	lVal = long(value) ;			fVal = float(value) ;	vw=7;	vp=0;	symb =  _T(" ") ;	}
	str = ::To_tstring_cs(::To_tstring	(u_32(lVal)))	+ symb ;
	str = ::To_tstring_cs(::To_tstring_f(fVal,vw,vp))	+ symb ;
	return	str ;
	}
inline	tstring	To_tstring_k   (const i_64	value) {
	tstring	str ;
	i_64	k_	 = 1000 ;
	i_64	kilo = 1	* k_ ;		//	10^3
	i_64	mega = kilo * k_ ;		//	10^6
	i_64	giga = mega * k_ ;		//	10^9
	i_64	tera = giga * k_ ;		//	10^12
	i_64	peta = tera * k_ ;		//	10^15
	i_64	exa_ = peta * k_ ;		//	10^18
//	i128	zett = exa_ * k_ ;		//	10^21
//	i128	yott = zett * k_ ;		//	10^24
	long	lVal = 0 ;
	float	fVal = 0 ;
	tstring	symb ;
	int		vw = 6 ;
	int		vp = 2 ;
	if		(value>=exa_)	{	lVal = long(value/(exa_)) ;		fVal = float(value)/float(exa_) ;		symb = _T(" E") ;	}
	else if	(value>=peta)	{	lVal = long(value/(peta)) ;		fVal = float(value)/float(peta) ;		symb = _T(" P") ;	}
	else if	(value>=tera)	{	lVal = long(value/(tera)) ;		fVal = float(value)/float(tera) ;		symb = _T(" T") ;	}
	else if	(value>=giga)	{	lVal = long(value/(giga)) ;		fVal = float(value)/float(giga) ;		symb = _T(" G") ;	}
	else if	(value>=mega)	{	lVal = long(value/(mega)) ;		fVal = float(value)/float(mega) ;		symb = _T(" M") ;	}
	else if	(value>=kilo)	{	lVal = long(value/(kilo)) ;		fVal = float(value)/float(kilo) ;		symb = _T(" k") ;	}
	else					{	lVal = long(value) ;			fVal = float(value) ;	vw=7;	vp=0;	symb =  _T(" ") ;	}
	str = ::To_tstring_cs(::To_tstring	(u_32(lVal)))	+ symb ;
	str = ::To_tstring_cs(::To_tstring_f(fVal,vw,vp))	+ symb ;
	return	str ;
	}

#ifdef	________Old____2017_06_06_____________
////
//	*******************************************************************************
//	To tstring	float
//	Create	:	2013/08/23
//	Modify	:	2013/08/29
//	*******************************************************************************
#define	FTTW	0
#define	FTTP	6
inline	tstring	To_tstring	(const double v,const int w=FTTW,const int p=FTTP,const unsigned f_=std::ios::fixed)	{
	tstring			str ;
	std::tostringstream	strBuf ;
	std::ios_base::fmtflags	f = std::ios_base::fmtflags(f_) ;
	if (f != 0)	{
		strBuf.flags(f) ;
		}
	{
		strBuf.width(w) ;
		strBuf.precision(p) ;
		}
	{
		strBuf << v ;
		}
	{
		str = strBuf.str() ;
		}
	return	str ;
	}
#endif	//

#ifdef	________Old_______
#include	<strstream>
inline	tstring	To_tstring	(const double v,const int w=0,const int p=6,const unsigned f_=std::ios::fixed)	{
	tstring			str ;
	std::ostrstream	strBuf ;
	std::ios_base::fmtflags	f = std::ios_base::fmtflags(f_) ;
	if (f != 0)	{
		strBuf.flags(f) ;
		}
	{
		strBuf.width(w) ;
		strBuf.precision(p) ;
		}
	{
		strBuf << v ;
		strBuf << std::ends ;
		}
	{
		str = strBuf.str() ;
		strBuf.rdbuf()->freeze(false) ;
		}
	return	str ;
	}
#endif	//	__________Old_________
