//	*******************************************************************************
//	Name	:	ttof.hxx
//			:	ttof , ttod
//	Author	:	I. Nakagawa
//	Create	:	2013/08/22
//	Modify	:	2013/09/12
//	Modify	:	2013/12/24
//	Modify	:	2014/07/17
//	Modify	:	2014/11/28
//	Modify	:	2015/06/23		Add c_tstring type
//	*******************************************************************************

#pragma		once

#include	<cstdlib>
#include	<iostream>
#include	"i_define.hxx"
#include	"ttox.hxx"

#ifdef		_MSC_VER
	#ifndef	_tcstof
	#define	_tcstof		_tcstod
	#endif
#else
	#define	_tcstof		strtof
	#define	_tcstod		strtod
	#define	_stscanf	sscanf
#endif

////
//	*******************************************************************************
//	Check use sscanf
//	Create	:	2017/06/20
//	Modify	:	2023/04/24
//	*******************************************************************************
inline	bool	Check_use_sscanf	(void)
{
	long	checkValue = 0 ;
	long	resultValue= 0 ;
	{
		#ifdef	_OPENMP
			#pragma	omp	critical	(Check_use_sscanf)
		#endif
		{
			tstring	checkStr = _T("128") ;
			TCHAR*	endPtr = 0 ;
			resultValue = long(_tcstod(checkStr.c_str(),&endPtr)) ;
			checkValue  = ::ttoi4(checkStr) ;
			#ifdef	_DEBUG
			if (long(checkValue)!=long(resultValue))
			{
				std::terr << long(checkValue) << _T("\t") << long(resultValue) << std::endl ;
				}
			#endif
			}
		}
	return	!(long(checkValue)==long(resultValue)) ;
	}

inline	double	ttod_scan	(LPCTSTR str)	{
	double	value = 0 ;
	#if		(_MSC_VER >= 1400)
	{
		TCHAR*	endPtr = 0 ;
		value = double(_tcstod(str,&endPtr)) ;
		}
	#else
	{
		_stscanf(str,_T("%lg"),&value) ;
		}
	#endif
	return	value ;
	}

////
//	*******************************************************************************
//	ttof ,	ttod
//	Create	:	2013/08/22
//	Modify	:	2013/09/12
//	Modify	:	2017/06/20	//	sscanf	for DS115j
//	*******************************************************************************
inline	float	ttof	(LPCTSTR str)	{
	{
		static	bool	use_sscanf = ::Check_use_sscanf() ;
		if (use_sscanf) {	return	float(::ttod_scan(str)) ;	}
		}
	TCHAR*	endPtr = 0 ;	float	value =  float(_tcstof(str,&endPtr)) ;	return	value ;
	}
inline	double	ttod	(LPCTSTR str)	{
	{
		static	bool	use_sscanf = ::Check_use_sscanf() ;
		if (use_sscanf) {	return	double(::ttod_scan(str)) ;	}
		}
	TCHAR*	endPtr = 0 ;	double	value = double(_tcstod(str,&endPtr)) ;	return	value ;
	}

////
//	*******************************************************************************
//	ttof ,	ttod
//	Create	:	2013/08/22
//	Modify	:	2013/09/12
//	Modify	:	2013/12/24
//	*******************************************************************************
//	inline	float	ttof	(LPCTSTR str)	{	TCHAR*	endPtr = 0 ;	float	value =  float(_tcstof(str,&endPtr)) ;	return	value ;	}
//	inline	double	ttod	(LPCTSTR str)	{	TCHAR*	endPtr = 0 ;	double	value = double(_tcstod(str,&endPtr)) ;	return	value ;	}

//	*******************************************************************************
//	ttof ,	ttod
//	Create	:	2015/06/23
//	*******************************************************************************
inline	float	ttof	(c_tstring&str)	{	return	::ttof(str.c_str()) ;	}
inline	double	ttod	(c_tstring&str)	{	return	::ttod(str.c_str()) ;	}

