//	*******************************************************************************
//	Name	:	ttox.hxx
//			:	ttou , ...
//	Author	:	I. Nakagawa
//	Create	:	2013/02/27
//	Modify	:	2013/10/09
//	*******************************************************************************

#pragma		once

//#ifndef T_TO_X
//#define T_TO_X

#include	"i_define.hxx"
#include	"tstring.hxx"

#ifdef	_MSC_VER
	#ifndef		_tcstoui64
	#include	"MS_tox64.hxx"
	#endif
#else
	#define	_tcstoul	strtoul
	#define	_tcstoui64	strtoull
	#define	_tcstol		strtol
	#define	_tcstoi64	strtoll
#endif

////
//	*******************************************************************************
//	ttou
//	Create	:	2013/02/28
//	Modify	:	2013/09/19
//	*******************************************************************************
inline	U_2	ttou2	(LPCTSTR   str,const int base=10)	{	return	U_2(::_tcstoul		(str,			NULL,base));	}
inline	U_4	ttou4	(LPCTSTR   str,const int base=10)	{	return	U_4(::_tcstoul		(str,			NULL,base));	}
inline	U_8	ttou8	(LPCTSTR   str,const int base=10)	{	return		::_tcstoui64	(str,			NULL,base) ;	}
inline	U_2	ttou2	(c_tstring&str,const int base=10)	{	return	U_2(::_tcstoul		(str.c_str(),	NULL,base));	}
inline	U_4	ttou4	(c_tstring&str,const int base=10)	{	return	U_4(::_tcstoul		(str.c_str(),	NULL,base));	}
inline	U_8	ttou8	(c_tstring&str,const int base=10)	{	return		::_tcstoui64	(str.c_str(),	NULL,base) ;	}

////
//	*******************************************************************************
//	ttoi
//	Create	:	2013/10/09
//	*******************************************************************************
//	inline	I_2	ttoi2	(LPCTSTR   str,const int base=10)	{	return	I_2(::_tcstol		(str,			NULL,base));	}
//	inline	I_4	ttoi4	(LPCTSTR   str,const int base=10)	{	return	I_4(::_tcstol		(str,			NULL,base));	}
//	inline	I_8	ttoi8	(LPCTSTR   str,const int base=10)	{	return		::_tcstoi64		(str,			NULL,base) ;	}
//	inline	I_2	ttoi2	(c_tstring&str,const int base=10)	{	return	I_2(::_tcstol		(str.c_str(),	NULL,base));	}
//	inline	I_4	ttoi4	(c_tstring&str,const int base=10)	{	return	I_4(::_tcstol		(str.c_str(),	NULL,base));	}
//	inline	I_8	ttoi8	(c_tstring&str,const int base=10)	{	return		::_tcstoi64		(str.c_str(),	NULL,base) ;	}
inline	I_2	ttoi2	(LPCTSTR   str)							{	return	I_2(::_tcstol		(str,			NULL,10));		}
inline	I_4	ttoi4	(LPCTSTR   str)							{	return	I_4(::_tcstol		(str,			NULL,10));		}
inline	I_8	ttoi8	(LPCTSTR   str)							{	return		::_tcstoi64		(str,			NULL,10) ;		}
inline	I_2	ttoi2	(c_tstring&str)							{	return	I_2(::_tcstol		(str.c_str(),	NULL,10));		}
inline	I_4	ttoi4	(c_tstring&str)							{	return	I_4(::_tcstol		(str.c_str(),	NULL,10));		}
inline	I_8	ttoi8	(c_tstring&str)							{	return		::_tcstoi64		(str.c_str(),	NULL,10) ;		}

//#endif
