//	*******************************************************************************
//	Name	:	xtot.hxx
//			:	itot , ltot , ...
//	Author	:	I. Nakagawa
//	Create	:	2013/02/25
//	Modify	:	2013/03/07
//	Modify	:	2014/12/18	Add disable 4786
//	Modify	:	2020/02/14	Add	u64to0t , u64to_t
//	Modify	:	2024/07/01	Add	ttot_
//	*******************************************************************************

#pragma		once

#ifdef		_MSC_VER
#pragma		warning	(disable	:	4786	)
#endif
#include	<algorithm>

#include	"i_define.hxx"
#include	"tstring.hxx"

#ifdef	_DEBUG
#include	<cassert>
#endif

////
//	*******************************************************************************
//	u64tot		...\VS 8\VC\crt\src\xtoa.c
//	Create	:	2013/02/26
//	Modify	:	2013/03/05
//	*******************************************************************************
inline	tstring	utot	(const u_64 val_,cUInt radix_)
{
	unsigned	radix	= radix_ ;
	tstring		str ;
	#ifdef	_DEBUG
	{
		u_64	val		= val_ ;
		do	{
			unsigned	digval = (unsigned)(val % radix) ;
			val /= radix ;
			TCHAR	c = 0 ;
			if (digval > 9)	{	c = (TCHAR)(digval-10+'a') ;	}
			else			{	c = (TCHAR)(digval   +'0') ;	}
			str = c + str ;
			}	while	(val > 0) ;
		}
	#endif
	{
		u_64	val		= val_ ;
		tstring	rStr ;
		do	{
			unsigned	digval = (unsigned)(val % radix) ;
			val /= radix ;
			TCHAR	c = 0 ;
			if (digval > 9)	{	c = (TCHAR)(digval-10+'a') ;	}
			else			{	c = (TCHAR)(digval   +'0') ;	}
			rStr += c ;
			}	while	(val > 0) ;
		std::reverse(rStr.begin(),rStr.end()) ;
		#ifdef	_DEBUG
			assert(str==rStr) ;
		#endif
		str = rStr ;
		}
	return	str ;
	}

////
//	*******************************************************************************
//	x32tot		...\VS 8\VC\crt\src\xtoa.c
//	Create	:	2013/02/26
//	*******************************************************************************
inline	tstring	x32tot	(const u_32 val_,cUInt radix_,c_Int is_neg=FALSE)
{
	u_32		val		= val_ ;
	unsigned	radix	= radix_ ;
	tstring		str ;
	if (radix <  2)		{	radix = 2 ;		}
	if (36 < radix)		{	radix =36 ;		}
	if (is_neg)	{
		str = _T("-") ;
		val = (u_32)(-(i_32)val) ;
		}
	str += ::utot(val,radix) ;
	return	str ;
	}

////
//	*******************************************************************************
//	x64tot
//	Create	:	2013/02/26
//	*******************************************************************************
inline	tstring	x64tot	(const u_64 val_,cUInt radix_,c_Int is_neg=FALSE)
{
	u_64			val		= val_ ;
	unsigned	radix	= radix_ ;
	tstring		str ;
	if (radix <  2)		{	radix = 2 ;		}
	if (36 < radix)		{	radix =36 ;		}
	if (is_neg)	{
		str = _T("-") ;
		val = (u_64)(-(i_64)val) ;
		}
	str += ::utot(val,radix) ;
	return	str ;
	}

////
//	*******************************************************************************
//	itot , ...
//	Create	:	2013/02/26
//	*******************************************************************************
inline	tstring	itot	(const int  value,const int radix=10)	{	return	::x32tot(u_32(value),radix,(radix==10&&value<0)) ;	}
inline	tstring	ltot	(const long value,const int radix=10)	{	return	::x32tot(u_32(value),radix,(radix==10&&value<0)) ;	}
inline	tstring	i32tot	(const i_32 value,const int radix=10)	{	return	::x32tot(u_32(value),radix,(radix==10&&value<0)) ;	}
inline	tstring	u32tot	(const u_32 value,const int radix=10)	{	return	::x32tot(u_32(value),radix,0) ;						}
inline	tstring	i64tot	(const i_64 value,const int radix=10)	{	return	::x64tot(u_64(value),radix,(radix==10&&value<0)) ;	}
inline	tstring	u64tot	(const u_64 value,const int radix=10)	{	return	::x64tot(u_64(value),radix,0) ;						}
//#define		xtot														x32tot

////
//	*******************************************************************************
//	"1234",5	-->	"01234"
//	Create	:	2013/02/27
//	Modify	:	2013/03/07
//	*******************************************************************************
inline	tstring	tto0t	(c_tstring&str_,const int width,const TCHAR c=_T('0'))
{
	tstring	str = str_ ;
	if (int(str.length()) >= width)	{	return	str ;	}
	int		spCount = width - int(str.length()) ;
	tstring	sp ;	sp.assign(spCount,c) ;
	return	(sp + str) ;
	}
inline	tstring	tto0t	(LPCTSTR str_,const int width,const TCHAR c=_T('0'))	{	return	::tto0t(c_tstring(str_),width,c) ;	}

////
//	*******************************************************************************
//	1234,10,5	-->	"01234"
//	Create	:	2013/02/27
//	Modify	:	2020/02/14	Add	u64to0t , u64to_t
//	*******************************************************************************
inline	tstring	u32to0t	(cU_32 value,c_Int radix,c_Int len)	{	return	::tto0t(::u32tot(value,radix),len) ;	}
inline	tstring	u32to_t	(cU_32 value,c_Int radix,c_Int len)	{	return	::tto0t(::u32tot(value,radix),len,' ');	}

inline	tstring	u64to0t	(cU_64 value,c_Int radix,c_Int len)	{	return	::tto0t(::u64tot(value,radix),len) ;	}
inline	tstring	u64to_t	(cU_64 value,c_Int radix,c_Int len)	{	return	::tto0t(::u64tot(value,radix),len,' ');	}

////
//	*******************************************************************************
//	"1234",5	-->	"1234 "
//	Create	:	2024/07/01
//	*******************************************************************************
inline	tstring	ttot_	(c_tstring&str_,const int width,const TCHAR c=_T(' '))
{
	tstring	str = str_ ;
	if (int(str.length()) >= width)	{	return	str ;	}
	tstring	sp ;	sp.assign(width,c) ;
	return	(str+sp).substr(0,width) ;
	}
inline	tstring	ttot_	(LPCTSTR str_,const int width,const TCHAR c=_T(' '))	{	return	::ttot_(c_tstring(str_),width,c) ;	}

